/*
	File:		CDEFTester.h

	Contains:	Code to demonstrate all types of controls.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(MAA)	Matt Ackeret
		(edv)	Ed Voas

	Change History (most recent first):

		 <5>	 11/7/97	MAA		Add special Boolean for tab
		 <4>	10/28/97	MAA		change fMenu to static
		 <3>	10/28/97	MAA		Put kMenuFonts/new fields here
		 <2>	10/28/97	edv		Use RadioGroup control!
		 <1>	 9/11/97	edv		First checked in.
*/

#ifndef _CDEFTESTER_H
#define _CDEFTESTER_H

#include <Controls.h>
#include "BaseWindow.h"

enum
{
	kMenuFonts				= 143
};


class CDEFTester : public BaseWindow
{
	public:
			CDEFTester();
			CDEFTester( SInt16 resID );
		virtual ~CDEFTester();
		
		virtual void		Activate( EventRecord& event );
		virtual void		Deactivate( EventRecord& event );
		virtual void		Draw(void);
		virtual void		HandleClick( EventRecord& event );
		virtual void		HandleMenuSelection( SInt16 menuID, SInt16 itemNo );
		virtual void		Idle(void);
		virtual void		HandleKeyDown( EventRecord& event );
		virtual	MenuHandle	GetMyMenu(void);
		
	private:
		void				DisplayPartCode( SInt16 part );
		void				CenterControlInWindow(void);
		void				SetValue(void);
		void				ChangeControlFont(SInt16 menuID, SInt16 itemNo);
		
		static	MenuHandle	fMenu;
		ControlHandle		fControl;
		Rect				fPartRect;
		Boolean 			fIsTab;
		
		ControlHandle		fDisableButton;
		ControlHandle		fSetValueButton;	
};

#endif // _CDEFTESTER_H
